<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html >
<head>
<meta charset="utf-8"/>
<title>IBSheet7-Product</title>

		<script type="text/javascript" src="../Chart/jquery-1.7.2.min.js"></script>
		<script type="text/javascript" src="../js/common.js"></script>
        <script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
		<script type="text/javascript" src="../Chart/ibchart.js"></script>
		<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>

		<script type="text/javascript">
			var pageheightoffset = 320;
			function init_chart(){
				var title = {
					text: '데이터 조회 테스트',
					align: "center",
					verticalAlign : "top",
					style:{
						margin: 15,
						x: 10,
						y: 10,
						fontSize: "15px",
						fontWeight:"bold"
					}
				};
				createIBChart("myChart", "myChart", {
					width: "100%",
					height: "275px"
				});

				myChart.setOptions({
					title : title,
					legend: {
						enabled:true,
						borderWidth:0,
						borderRadius:0,
						itemStyle:{fontSize:"8pt"},
						symbolHeight:8,
						symbolWidth:8,
						padding:2,
						margin:0,
						symbolPadding:0
					},
					yAxis: [{
						title:{
							enabled:false
						},
						style:{
							color:"#daa520",
							fontWeight:'bold',
							fontSize:'15px'
						},
						labels:{
							formatter:function(){
								var temp = (this.value).toLocaleString()+"";
								if(temp.indexOf(".")>0) temp = temp.substring(0,temp.indexOf("."));
								return temp;
							}
						}
					},{
						opposite:1
					}]
				});
			}

			function doAction(str){
				switch(str){
					case 'search':
					DoSearch(myChart, "practice3_data.jsp"+"?SERIES_CNT="+document.getElementById("series_cnt").value,{
						append: true
					});

					break;
					// case 'load':
					// var scnt = document.getElementById("series_cnt").value;
					// DoSearch(myChart, "practice3_data.xml",{
					// 	param : {
					// 		SERIES_CNT : scnt
					// 	},
					// 	append: true
					// });
					// break;
				}

			}

			function myChart_OnSearchEnd(Code, Msg) {

			}

			function DoSearch(chart,url,subparam){
				$.ajax({
					type: 'post'
					, async: subparam.sync
					, dataType:"text"
					, url: url
					, data: subparam.param
					, beforeSend: function() {

					}
					, success: function(xml) {
						chart.loadSearchData(xml,subparam);
					}
					, error: function(data, status, err) {
						alert('서버와의 통신이 실패했습니다.');
					}
					,complete:function(jqXHR,textStatus){

					}
				});
			}
		</script>
	</head>

<body onload="init_chart()">

        <div class="page_title">
            <span><a class="closeDepth" href="#">closeDepth</a></span>
            <span class="title color_sheet">차트개발 실습  > <b>데이터 조회</b></span>
        </div>

        <div class="main_content">
            <div class="exp_product">
               조회 데이터 XML을 서버로부터 가져오는 방법을 확인합니다.
            </div>

            <p class="subtit_chart">기능 버튼</p>
            <div class="ib_function2 border_chart">
            	<table class="ib_column2">
            		<tr>
            			<th class="tit">시리즈 개수</th>
            			<td class="r20">
            				<select name="series_cnt"  id="series_cnt">
            					<option value="1">1</option>
            					<option value="2">2</option>
            					<option value="3">3</option>
            					<option value="4">4</option>
            					<option value="5">5</option>
            					<option value="6">6</option>
            					<option value="7">7</option>
            					<option value="8">8</option>
            					<option value="9">9</option>
            					<option value="10">10</option>
            				</select>
            			</td>
            			<th class="tit">조회데이터 가져오기</th>
            			<td class="r20">
            				<a href="javascript:doAction('search');" class="f2_btn_white btn_chart">확인</a>
            			</td>
<!--
						<th class="tit">XML String Load</th>
						<td class="r20">
							<a href="javascript:doAction('load');;" class="f2_btn_white btn_chart">확인</a>
						</td>
 -->
					</tr>
				</table>
          	</div>
			<p class="subtit_chart">IB Chart</p>
			<br/>
            <div class="ib_product">
            	<div id="myChart"> </div>
            </div>
        </div>
    </div>
    <!--main_content-->
</body>
</html>








